/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.api.crafting.RecipeTypes;
import com.blakebr0.extendedcrafting.init.ModRecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapelessTableRecipe
implements ISpecialRecipe,
ITableRecipe {
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final int tier;
    private Map<Integer, Function<ItemStack, ItemStack>> transformers;

    public ShapelessTableRecipe(ResourceLocation recipeId, NonNullList<Ingredient> inputs, ItemStack output) {
        this(recipeId, inputs, output, 0);
    }

    public ShapelessTableRecipe(ResourceLocation recipeId, NonNullList<Ingredient> inputs, ItemStack output, int tier) {
        this.recipeId = recipeId;
        this.inputs = inputs;
        this.output = output;
        this.tier = tier;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipeSerializers.SHAPELESS_TABLE;
    }

    public RecipeType<?> m_6671_() {
        return RecipeTypes.TABLE;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.inputs.size();
    }

    public ItemStack assemble(IItemHandler inventory) {
        return this.output.m_41777_();
    }

    public ItemStack m_5874_(Container inv) {
        return this.output.m_41777_();
    }

    public boolean matches(IItemHandler inventory) {
        if (this.tier != 0 && this.tier != ShapelessTableRecipe.getTierFromSize(inventory.getSlots())) {
            return false;
        }
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int matched = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            inputs.add(stack);
            ++matched;
        }
        return matched == this.inputs.size() && RecipeMatcher.findMatches(inputs, this.inputs) != null;
    }

    public boolean m_5818_(Container inv, Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    public NonNullList<ItemStack> m_7457_(Container inv) {
        if (this.transformers != null) {
            NonNullList remaining = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
            this.transformers.forEach((i, stack) -> remaining.set(i.intValue(), (Object)((ItemStack)stack.apply(inv.m_8020_(i.intValue())))));
            return remaining;
        }
        return super.m_7457_(inv);
    }

    @Override
    public int getTier() {
        if (this.tier > 0) {
            return this.tier;
        }
        return ShapelessTableRecipe.getTierFromSize(this.inputs.size());
    }

    @Override
    public boolean hasRequiredTier() {
        return this.tier > 0;
    }

    private static int getTierFromSize(int size) {
        return size < 10 ? 1 : (size < 26 ? 2 : (size < 50 ? 3 : 4));
    }

    public void setTransformers(Map<Integer, Function<ItemStack, ItemStack>> transformers) {
        this.transformers = transformers;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ShapelessTableRecipe> {
        public ShapelessTableRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList inputs = NonNullList.m_122779_();
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.add((Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int tier = GsonHelper.m_13824_((JsonObject)json, (String)"tier", (int)0);
            return new ShapelessTableRecipe(recipeId, (NonNullList<Ingredient>)inputs, output, tier);
        }

        public ShapelessTableRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            int tier = buffer.m_130242_();
            return new ShapelessTableRecipe(recipeId, (NonNullList<Ingredient>)inputs, output, tier);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapelessTableRecipe recipe) {
            buffer.m_130130_(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.output);
            buffer.m_130130_(recipe.tier);
        }
    }
}

